:- sorts location >> block;
         time >> step.

:- variables
        T1 :: time;
        B, B1, B2 :: block;
        L, L1 :: location;
        T :: step.

:- constants
        table :: location;
        0..maxtime-1 :: step;
	maxtime :: time;
        on(block, location, time), 
        move(block, location, step) :: atomicFormula.

:- macros 
	next(#1,#2) -> (#2) is (#1) + 1.

% effect of moving a block
on(B,L,T1) :- move(B,L,T), next(T,T1).

% a block can be moved only when it's clear 
:- move(B,L,T), on(B1,B,T).

% any two blocks cannot be on the same block at the same time.
:- on(B2,B,T1), on(B1,B,T1), B1 @< B2.

% wherever a block is, it's not anywhere else
-on(B,L1,T1) :- on(B,L,T1), -(L=L1).

% no concurrency
:- move(B,L,T), move(B1,L1,T), B @< B1.
:- move(B,L,T), move(B1,L1,T), L @< L1.

% inertia
on(B,L,T1) :- on(B,L,T), next(T,T1), not -on(B,L,T1).

% initial values and actions are exogeneous
on(B,L,0) :- not -on(B,L,0).
-on(B,L,0) :- not on(B,L,0).
move(B,L,T) :- not -move(B,L,T).
-move(B,L,T) :- not move(B,L,T).
